unit UTestForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  UConsts,
  UPlotno;

type
  TTestForm = class(TForm)
    PaintBox: TPaintBox;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);

  private
    procedure Start();
  public

  end;

var
  TestForm: TTestForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TTestForm.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TTestForm.BitBtn2Click(Sender: TObject);
begin
	Start();
end;

procedure TTestForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TTestForm.FormDestroy(Sender: TObject);
begin
	TestForm := Nil;
end;

procedure TTestForm.FormShow(Sender: TObject);
begin
	PaintBox.Align := alClient;
end;

procedure TTestForm.Start();
var
	ob_druk : MPrint;
   f       : TFont;

begin
	ob_druk := Nil;
	f       := TFont.Create();
   
	ob_druk := MPrint.Create(PaintBox.Canvas, 40, 40);

	f.Name := 'Times New Roman';
	f.Size := 10;
	f.Color := clBlack;
	f.Style := [];
	ob_druk.Add('Wiersz 1', f, WRITE);
	f.Name := 'Courier';
	f.Size := 12;
	f.Color := clGreen;
	f.Style := [fsBold, fsItalic];
	ob_druk.Add('Obok niego drugi pierwszy', f);

	f.Style := [];
	f.Name := 'Arial';
	f.Size := 14;
	f.Color := clMaroon;
	ob_druk.Add('Wiersz 2', f);

	f.Name := 'Verdana';
	f.Size := 16;
	f.Color := clBlue;
	ob_druk.Add('Wiersz 3', f);

	f.Name := 'Arial';
	f.Color := clBlack;
	f.Style := [];
	f.Size := 18;
	ob_druk.Add('Wiersz 4', f);

   // tylko odstp
	ob_druk.Add(CRLF, f);

	f.Name := 'Courier';
	f.Color := clRed;
	f.Style := [fsItalic];
	f.Size := 8;
	ob_druk.Add('Wiersz 6', f);

	// jeszcze raz odstp
	ob_druk.Add('', f);

	f.Name := 'Times New Roman CE';
	f.Color := clNavy;
	f.Style := [fsStrikeOut];
	f.Size := 20;
	ob_druk.Add('Wiersz 8', f);

   // powoduje wywietlenie na ekranie
	ob_druk.Show();

	if Assigned(ob_druk) then
	begin
		FreeAndNil(ob_druk);
   end;
	
	if Assigned(f) then
	begin
		FreeAndNil(f);
   end;
end;

end.

